clear all
set more off

capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

*==================================================================
*			historical unemployment rate
*			Source: OECD
*==================================================================

insheet using "OECD - annual unemployment rates.csv", clear

replace location="AT" if location=="AUT"
replace location="BE" if location=="BEL"
replace location="CH" if location=="CHE"
replace location="DE" if location=="DEU"
replace location="DK" if location=="DNK"
replace location="EL" if location=="GRC"
replace location="UK" if location=="GBR"
replace location="ES" if location=="ESP"
replace location="FI" if location=="FIN"
replace location="FR" if location=="FRA"
replace location="IT" if location=="ITA"
replace location="NL" if location=="NLD"
replace location="PT" if location=="PRT"
replace location="SE" if location=="SWE"
replace location="US" if location=="USA"
replace location="CA" if location=="CAN"

gen insample=0
foreach country in "AT" "BE" "CH" "DE" "DK" "EL" "ES" "FI" "FR" "IT" "NL" "PT" "SE" "UK" "US" "CA" {
	quietly replace insample= 1 if location=="`country'"
}
keep if insample==1
rename time year
keep location year value
rename location country
rename value UR
compress

egen cid=group(country)
tsset cid year

save oecd_UE_rates, replace


*==================================================================
*			cultural variables
*==================================================================
use "ZA4804_v2-0-0.dta"

desc a005 a003 a030 c037 c038 c039 c041 a165  a168a f114 a029 e035 e036 e037 e039


rename s009 country
replace country =  "UK" if country== "GB-GBN"
replace country =  "UK" if country== "GB-NIR"
replace country =  "EL" if country== "GR"

foreach var in a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039 ///
	{
	noisily di "========================================================="
	noisily di "                     `var'"
	noisily di "========================================================="

	tab `var'
	}
	
	
gen insample=0
foreach country in "AT" "BE" "CH" "DE" "DK" "EL" "ES" "FI" "FR" "IT" "NL" "PT" "SE" "UK" "US" "CA" {
	quietly replace insample= 1 if country=="`country'"
}
keep if insample==1

rename s020 year

keep country year ///
	s017 /// weights
	a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039

compress

gen EVS=1
tab country year
save step1302_WVS_core, replace


**** US & CA
use wvs1981_2008_v20090914.dta, clear 

gen country=""

replace country="US" if s003==840
replace country="CA" if s003==124

keep if country~=""


rename s020 year

keep country year ///
	s017  /// weights
	a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039
gen EVS=0
tab country year	
append using step1302_WVS_core

compress
tab country year
save step1302_WVS_core, replace	



egen bin_cy=group(country year)
sum a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039
	
foreach var in 	a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039 ///
	{
	tabstat `var', by(bin_cy) stat(N mean sd min max)
	}
	

	
egen cid=group(country)
egen yid=group(year)



	
*=======================================================
*			construct index
*=======================================================
gen WVS_index_1 = a005/.263 - a003/.202 + a030/.203 + c037/.423 + c038/.382 + c039/.282 + c041/.423
label var WVS_index_1     "WVS: Work ethic"

gen WVS_index_2 = -(a165/.196 - a168a/1.071 + f114/1.212)
label var WVS_index_2     "WVS: Trust"

gen WVS_index_3 = a029/0.17518 + e035/1.011 - e036/.696 -e039/0.754 - e037/.912531
label var WVS_index_3     "WVS: Individualism"

*===============================================================
*					plot time series
*===============================================================
gen ones=1	

collapse (mean) ///
	a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039 ///
	(sd) ///
	a005_sd = a005 a003_sd = a003 a030_sd = a030 c037_sd = c037 c038_sd = c038 c039_sd = c039 c041_sd = c041 ///
	a165_sd = a165  a168a_sd = a168a f114_sd = f114 ///
	a029_sd = a029 e035_sd = e035 e036_sd = e036 e037_sd = e037 e039_sd = e039 ///	
	(min) ///
	a005_min = a005 a003_min = a003 a030_min = a030 c037_min = c037 c038_min = c038 c039_min = c039 c041_min = c041 ///
	a165_min = a165  a168a_min = a168a f114_min = f114 ///
	a029_min = a029 e035_min = e035 e036_min = e036 e037_min = e037 e039_min = e039 ///	
	(max) ///
	a005_max = a005 a003_max = a003 a030_max = a030 c037_max = c037 c038_max = c038 c039_max = c039 c041_max = c041 ///
	a165_max = a165  a168a_max = a168a f114_max = f114 ///
	a029_max = a029 e035_max = e035 e036_max = e036 e037_max = e037 e039_max = e039 ///		
	(count) Nobs = ones [aw=s017], by(country year)

save C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\step1302_WVS_core2, replace

           
*======================================================================
*		sensitivity fo cultural variables to unemployment rates
*======================================================================
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use oecd_UE_rates, clear

joinby country year using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\step1302_WVS_core2, unmatched(both)
tab _merge
tab country _merge
tab year _merge
drop _merge

gen decade=1970 if year>=1970 & year<1980
replace decade=1980 if year>=1980 & year<1990
replace decade=1990 if year>=1990 & year<2000
replace decade=2000 if year>=2000

gen WVS_index_1 = a005/.263 - a003/.202 + a030/.203
	
gen WVS_index_2 = -(a165/.196 + f114/1.212)
	
gen WVS_index_3 = a029/0.17518 + e035/1.011 - e036/.696 -e039/0.754 - e037/.912531

tempname 1 
postfile `1' str20 varname str20 coef_se str4 R2 Nobs ///
			using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\result_4005, replace every(1)
			
foreach var in a003 a005  a030 ///
	a165   f114 ///
	a029 e035  e036 e037 e039 ///
	WVS_index_1 WVS_index_2 WVS_index_3 ///
	{
		areg `var' UR, absorb(cid) 
		
			local t1=abs(_b[UR]/_se[UR])
		
			if `t1'>1.65 {
				local st1t=string(_b[UR],"%9.3f")+"*"
			}	
			if `t1'>1.92 {
				local st1t=string(_b[UR],"%9.3f")+"**"
			}		
			if `t1'>2.33 {
				local st1t=string(_b[UR],"%9.3f")+"***"
			}

			if `t1'<=1.65 {
				local st1t=string(_b[UR],"%9.3f")
			}	
		
			local st1A="`st1t'"	
			local st2A="("+string(_se[UR],"%9.3f") + ")"
			
			local R2=string(e(r2),"%3.2f")
			local Nobs=e(N)
			
		post `1' ("`var'")  ("`st1A'") ("`R2'") (`Nobs')  
		post `1' ("")  	("`st2A'") ("") (.)  		
	}

postclose `1'

